unit stylesb;

interface

uses
  Classes, Graphics, Controls, Buttons;

type
  TStyleSpeedButton = class(TSpeedButton)
  private
    FStyle: TButtonStyle;
    procedure SetStyle(Value: TButtonStyle);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Style: TButtonStyle read FStyle write SetStyle default bsAutoDetect;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Additional', [TStyleSpeedButton]);
end;

procedure TStyleSpeedButton.SetStyle(Value: TButtonStyle);
begin
  if Value <> FStyle then
  begin
    FStyle := Value;
    Invalidate;
  end;
end;

constructor TStyleSpeedButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FStyle := bsAutoDetect;
  Height := 22;
  Width := 23;
end;

procedure TStyleSpeedButton.Paint;
begin
  inherited Paint;
  if ((FStyle = bsAutodetect) and NewStyleControls) or (FStyle = bsNew) then
    with canvas do
    begin
      if FState in [bsDown, bsExclusive] then
      begin
        Pen.Color := clBtnHighLight;
        PolyLine([Point(0, Height-1), Point(Width-1, Height-1), Point(Width-1, -1)] );
        PolyLine([Point(1, Height-2), Point(Width-2, Height-2), Point(Width-2, 0)] );
      end else
      begin
        Pen.Color := clBtnHighLight;
        PolyLine([Point(0, Height-2), Point(0, 0), Point(Width-1, 0)] );
        PolyLine([Point(1, Height-3), Point(1, 1), Point(Width-2, 1)] );
      end;
    end else
  if ((FStyle = bsAutodetect) and (not NewStyleControls)) or (FStyle = bsWin31) then
    with canvas do
    begin
      if FState in [bsDown, bsExclusive] then
      begin
        Pen.Color := clBlack;
        PolyLine([Point(1, Height-1), Point(Width-1, Height-1), Point(Width-1, 0)] );
        Pixels[0, 0] := clBtnFace;
        Pixels[Width-1, 0] := clBtnFace;
        Pixels[0, Height-1] := clBtnFace;
        Pixels[Width-1, Height-1] := clBtnFace;
      end else
      begin
        Pen.Color := clBlack;
        PolyLine([Point(1, 0), Point(Width-1, 0)] );
        PolyLine([Point(0, 1), Point(0, Height-1)] );
        Pixels[0, 0] := clBtnFace;
        Pixels[Width-1, 0] := clBtnFace;
        Pixels[0, Height-1] := clBtnFace;
        Pixels[Width-1, Height-1] := clBtnFace;
        Pen.Color := clBtnHighLight;
        PolyLine([Point(1, Height-3), Point(1, 1), Point(Width-2, 1)] );
        Pen.Color := clBtnShadow;
        PolyLine([Point(2, Height-3), Point(Width-3, Height-3), Point(Width-3, 1)] );
      end;
    end;
end;

end.

